//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see http://www.gnu.org/licenses/.
//

#ifndef ROUTINGTABLEENTRY_H_
#define ROUTINGTABLEENTRY_H_

#include "RoutingTable6.h"

#include "RIPngTimer_m.h"

namespace RIPng
{

/**
 *  Just extends IPv6 route for RIPng.
 */
class RoutingTableEntry : public IPv6Route
{
  public:
    RoutingTableEntry(IPv6Address destPrefix, int length);
    virtual ~RoutingTableEntry();

  protected:
    RIPngTimer *timeout;  ///< Pointer for the Route timeout timer
    RIPngTimer *GBC;      ///< Pointer for the Route Garbage-Collection Timer
    bool changeFlag;      ///< The Route Changed Flag

  public:
    bool isChangeFlagSet() { return changeFlag; }
    void setChangeFlag() { changeFlag = true; }
    void clearChangeFlag() { changeFlag = false; }

    const RIPngTimer *getTimeoutTimer() { return timeout; }
    void             setTimeoutTimer()  {  } // TODO:
    void             resetTimeoutTimer() {  } // TODO:

    const RIPngTimer *getGBCTimer() { return GBC; }
    void             setGBCTimer() {  } // TODO:
    void             resetGBCTimer() {  } // TODO:
};

} /* namespace RIPng */

#endif /* ROUTINGTABLEENTRY_H_ */
